package FlashReader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Tag extends SwfTools{
	
	protected int pos;
	protected int opcode;
	protected int length;
	protected ByteBuffer date;
	protected SWF swf;
	
	public Tag(int posId, int opcode, byte[] date,SWF swf, boolean nic){ //dodanie
		super();
		this.swf = swf;
		this.opcode=opcode;
		this.length=date.length;
		//alokuj odpowiedni ilo dla wczytanego pliku
		this.date = ByteBuffer.allocate(date.length);
		//Ustawiam kolejno bitw na LITTLE ENDIAN
		this.date.order(ByteOrder.LITTLE_ENDIAN);
		this.date.put(date);
		SWF.EN_Tag.add(this);
	}
	
	
	public Tag(int pos, int opcode, byte[] date, SWF swf){ //wczytane
		super();
		this.swf = swf;
		this.pos = pos;
		this.opcode=opcode;
		this.length=date.length;
		//alokuj odpowiedni ilo dla wczytanego pliku
		this.date = ByteBuffer.allocate(date.length);
		//Ustawiam kolejno bitw na LITTLE ENDIAN
		this.date.order(ByteOrder.LITTLE_ENDIAN);
		this.date.put(date);
		SWF.EN_Tag.add(this);
		
	}

	public int getPos() {
		return pos;
	}


	public void setPos(int pos) {
		this.pos = pos;
	}


	public int getopcode() {
		return opcode;
	}


	public void setopcode(int opcode) {
		this.opcode = opcode;
	}


	public int getLength() {
		return length;
	}


	public void setLength(int length) {
		this.length = length;
	}


	public ByteBuffer getDate() {
		return date;
	}


	public void setDate(ByteBuffer date) {
		this.date = date;
		this.length = date.capacity();
	}
	
	public void setDate(byte [] date) {
		ByteBuffer bbuf = ByteBuffer.allocate(date.length);
		bbuf.order(ByteOrder.LITTLE_ENDIAN);

		this.date = bbuf;
		this.length = bbuf.capacity();
	}
	
	
	public ByteBuffer getBytes(){

		ByteBuffer bbuf;
		
		if(date.capacity()<61){//2 bytes
			bbuf = ByteBuffer.allocate(2+length);
			bbuf.order(ByteOrder.LITTLE_ENDIAN);
			
			int tag = (opcode<<6 | length>>10) + length; //2 bajty
			bbuf.putShort((short)tag);
		}else{//6 bytes
			bbuf = ByteBuffer.allocate(6+length);
			bbuf.order(ByteOrder.LITTLE_ENDIAN);
			int tag = (opcode<<6 | 0x3f>>10)+0x3f;//2 bajty
			bbuf.putShort((short)tag);
			bbuf.putInt(length);
		}
		date.position(0);
		bbuf.put(date);
		
		bbuf.position(0);
		return bbuf;
	}
	
	
	public String toString(){
		return "OP - " + opcode + " " +SWF.tags.get(opcode) +" OFFSET - " + pos + " POSITION_ID - " + SWF.EN_Tag.indexOf(this);
	}
	
	
}
